/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.constants.RoleType;
import noppes.npcs.api.entity.data.role.IRoleTrader;
import noppes.npcs.api.handler.data.IMarcet;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.MarcetController;
import noppes.npcs.controllers.data.Marcet;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleInterface;

public class RoleTrader
extends RoleInterface
implements IRoleTrader {
    private int marcetID = -1;

    public RoleTrader(EntityNPCInterface npc) {
        super(npc);
        this.type = RoleType.TRADER;
    }

    @Override
    public IMarcet getMarket() {
        return MarcetController.getInstance().getMarcet(this.marcetID);
    }

    @Override
    public int getMarketID() {
        return this.marcetID;
    }

    @Override
    public void interact(EntityPlayer player) {
        this.npc.say(player, this.npc.advanced.getInteractLine());
        Marcet marcet = (Marcet)this.getMarket();
        if (marcet == null || !marcet.isValid()) {
            return;
        }
        if (player instanceof EntityPlayerMP) {
            marcet.addListener(player, true);
            PlayerData.get((EntityPlayer)player).game.getMarcetLevel(this.marcetID);
        }
        NoppesUtilServer.sendOpenGui(player, EnumGuiType.PlayerTrader, this.npc);
    }

    @Override
    public void load(NBTTagCompound compound) {
        super.load(compound);
        this.type = RoleType.TRADER;
        this.marcetID = !compound.func_150297_b("MarketID", 3) ? MarcetController.getInstance().loadOld(compound) : compound.func_74762_e("MarketID");
    }

    @Override
    public void setMarket(IMarcet marcet) {
        IMarcet m = this.getMarket();
        if (m != null) {
            ((Marcet)m).closeForAllPlayers();
        }
        this.marcetID = marcet.getId();
    }

    @Override
    public void setMarket(int id) {
        IMarcet m = this.getMarket();
        if (m != null) {
            ((Marcet)m).closeForAllPlayers();
        }
        this.marcetID = id;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound compound) {
        super.save(compound);
        compound.func_74768_a("MarketID", this.marcetID);
        return compound;
    }
}

